/*
 * AgentState.java
 *
 * 
 */
 package DisCSP.DistributedCSP;

import java.net.*;
import java.util.Vector;

/**
 * @ version 1.0
 *
 * @ author Nocerino Francesca
 *
 * @ since JDK 1.4
 *
 */


 class AgentState
{
	private boolean impossible = false;
	private boolean consistent = false;
	private boolean waiting = false;
	private int initiative=0;
	private String name;
	private InetAddress address;
	private int port;
	private String monitorAddr;
	private int monitorPort;
	private Vector receivedMarker;
	
 	/** Costruttore di AgentState
     * 
     * @param name il nome dell'agente
     * @param addr l'IP dell'agente
     * @param p la porta dell'agente
     * @param ma l'IP del Monitor
     * @param mp la porta del Monitor
     * 
     */		
	public AgentState(String n,String addr,int p,String ma,int mp) 
	{
		name=n;
		try
		{	
			address=InetAddress.getByName(addr);
		}
		catch(UnknownHostException he)
		{
			
		}
		port=p;
		monitorAddr=ma;
		monitorPort=mp;
		receivedMarker=new Vector();
	}
	
	/**Permette di verificare se il problema  senza soluzione
     * 
     * @return true se il problema  senza soluzione, false altrimenti
     * 
     */		
	public boolean impossible()
	{
		return impossible;
	}
	
	/** Permette di specificare se il problema  senza soluzione
     * 
     * @param imp true se il problema  senza soluzione, false altrimenti
     * 
     */		
	public void setImpossible(boolean imp)
	{
		impossible=imp;
	}
	
	/**Permette di verificare se il problema  consistente
     * 
     * @return true se il problema  consistente, false altrimenti
     * 
     */			
	public boolean consistent()
	{
		return consistent;
	}
	
	/** Permette di specificare se il problema  consistente
     * 
     * @param imp true se il problema  consistente, false altrimenti
     * 
     */		
	public void setConsistent(boolean c)
	{
		consistent=c;
	}
	
	/**Permette di verificare se l'agente  in stato di waiting
     * 
     * @return true se l'agente  in stato di waiting, false altrimenti
     * 
     */			
	public boolean waiting()
	{
		return waiting;
	}
	
	/** Permette di specificare se l'agente  in stato di waiting
     * 
     * @param imp true se l'agente  in stato di waiting, false altrimenti
     * 
     */			
	public void setWaiting(boolean w)
	{
		waiting=w;
	}
	
	/** Restituisce il nome dell'agente
     * 
     * @return il nome dell'agente
     * 
     */			
	public String getName()
	{
		return name;
	}
	
	/** Restituisce l'indirizzo IP dell'agente come stringa
     * 
     * @return una stringa rappresentante l'indirizzo IP dell'agente
     * 
     */		

	public String address()
	{
		return address.getHostAddress();
	}
	
	/** Restituisce la porta dell'agente
     * 
     * @return l'intero corrispondente alla porta dell'agente
     * 
     */			
	public int port()
	{
		return port;
	}
	
	/** Restituisce la porta del monitor
     * 
     * @return l'intero corrispondente alla porta del monitor
     * 
     */			
	public int monitorPort()
	{
		return monitorPort;
	}
	
	/** Restituisce l'indirizzo IP del monitor
     * 
     * @return l'indirizzo IP del monitor
     * 
     */					
	public InetAddress monitorAddr() throws UnknownHostException
	{
		return InetAddress.getByName(monitorAddr);
	}
	
	/** Incrementa il numero di inizitive prese dall'agente per segnalare il raggiungimento dell'arc-consistenza
     * 
     * 
     */					
	public void incrInitiative()
	{
		initiative++;
	}
	/** Restituisce il numero di inizitive prese dall'agente per segnalare il raggiungimento dell'arc-consistenza
     * 
     * @return il numero di inizitive
     * 
     */					
	
	public int initiative()
	{
		return initiative;
	}
	
	/** Verifica se l'agente ha gi inviato un certo marker
     * 
     * @return true se l'agente ha gi inviato un certo marker, false altrimenti
     * 
     */					
	public boolean	receivedMarker(String mark)
	{
		return receivedMarker.contains(mark);
	}
	
	/** Memorizza un marker
     * 
     * @return mark il marker
     * 
     */					
	
	public void	insertMarker(String mark)
	{
		receivedMarker.add(mark);
	}

}
